/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.sdgraph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.sdgraph.AbstractSdgEdge;
import cz.insophy.inplan.sdgraph.AbstractSdgNode;
import cz.insophy.inplan.sdgraph.EdgeMaker;
import cz.insophy.inplan.sdgraph.InterGarSdgEdge;
import cz.insophy.inplan.sdgraph.PriorityFifoEdgeMaker;
import cz.insophy.inplan.sdgraph.SdgCrNode;
import cz.insophy.inplan.sdgraph.SdgEdge;
import cz.insophy.inplan.sdgraph.SdgEsaNode;
import cz.insophy.inplan.sdgraph.SdgGarNode;
import cz.insophy.inplan.sdgraph.SdgGorNode;
import cz.insophy.inplan.sdgraph.SdgMatprodNode;
import cz.insophy.inplan.sdgraph.SdgNode;
import cz.insophy.inplan.sdgraph.SdgSrNode;
import cz.insophy.inplan.sdgraph.StoreDependencyGraph;
import cz.insophy.inplan.sdgraph.StoreDependencyGraphImpl;
import cz.insophy.inplan.sdgraph.UnplannedEdgeMaker;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.ExternalStoreActivity;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.Superplan;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class StoreDependencyGraphBuilder {
    private final Superplan superplan;
    private final NodeMode nodeMode;
    @Nonnull
    private final Function<StoreDependencyGraphBuilder, EdgeMaker> edgeMakerFactory;
    private final Map<Material, SdgMatprodNode> materialNodes;
    private final Map<GeneralizedActionRequest, SdgGarNode> garNodes;
    private final Map<GeneralizedOrderRequest, SdgGorNode> gorNodes;
    private final Map<SupplyRequest, SdgSrNode> srNodes;
    private final Map<CustomerRequest, SdgCrNode> crNodes;
    private final Map<ExternalStoreActivity, SdgEsaNode> esaNodes;
    private final ListMultimap<SdgNode, AbstractSdgEdge> incomingEdges;
    private final ListMultimap<SdgNode, AbstractSdgEdge> outgoingEdges;
    private final List<SdgEdge> allEdges;

    private StoreDependencyGraphBuilder(@Nonnull Superplan superplan, @Nonnull NodeMode nodeMode, @Nonnull Function<StoreDependencyGraphBuilder, EdgeMaker> edgeMakerFactory) {
        this.superplan = Preconditions.checkNotNull(superplan, "superplan");
        this.nodeMode = Preconditions.checkNotNull(nodeMode, "nodeMode");
        this.edgeMakerFactory = Preconditions.checkNotNull(edgeMakerFactory, "edgeMakerFactory");
        this.materialNodes = Maps.newHashMap();
        this.garNodes = Maps.newHashMap();
        this.gorNodes = Maps.newHashMap();
        this.srNodes = Maps.newHashMap();
        this.crNodes = Maps.newHashMap();
        this.esaNodes = Maps.newHashMap();
        this.incomingEdges = ArrayListMultimap.create();
        this.outgoingEdges = ArrayListMultimap.create();
        this.allEdges = Lists.newArrayList();
    }

    public static StoreDependencyGraphBuilder createWithPriorityFifo(Superplan superplan, NodeMode nodeMode) {
        return new StoreDependencyGraphBuilder(superplan, nodeMode, PriorityFifoEdgeMaker::new);
    }

    public static StoreDependencyGraphBuilder createForUnplanned(Superplan superplan, Iterable<UnplannedEdgeMaker.ExternalEdge> edges) {
        return new StoreDependencyGraphBuilder(superplan, NodeMode.GOR, b -> new UnplannedEdgeMaker((StoreDependencyGraphBuilder)b, edges));
    }

    public StoreDependencyGraph build() {
        Preconditions.checkState(this.allEdges.isEmpty(), "build must be called only once per builder instance");
        if (this.nodeMode == NodeMode.GAR) {
            this.addGarEdges();
        }
        this.edgeMakerFactory.apply(this).makeEdges();
        this.checkForCycles();
        this.addIsolatedNodes();
        return this.createGraph();
    }

    @Nonnull
    public Superplan getSuperplan() {
        return this.superplan;
    }

    @Nonnull
    public NodeMode getNodeMode() {
        return this.nodeMode;
    }

    private Iterable<SdgNode> getAllNodes() {
        return Iterables.concat(ImmutableList.of(this.materialNodes.values(), this.garNodes.values(), this.gorNodes.values(), this.srNodes.values(), this.crNodes.values(), this.esaNodes.values()));
    }

    private void checkForCycles() {
        ArrayDeque<SdgNode> stack = new ArrayDeque<SdgNode>();
        IdentityHashMap<SdgNode, Void> checkedNodes = new IdentityHashMap<SdgNode, Void>();
        for (SdgNode node : this.getAllNodes()) {
            this.checkNodeForCycles(node, stack, checkedNodes);
        }
    }

    private void checkNodeForCycles(SdgNode node, Deque<SdgNode> stack, Map<SdgNode, Void> checkedNodes) {
        if (checkedNodes.containsKey(node)) {
            return;
        }
        if (stack.contains(node)) {
            throw new IllegalStateException("Graph contains cycles.");
        }
        stack.addLast(node);
        for (AbstractSdgEdge edge : this.outgoingEdges.get((Object)node)) {
            SdgNode succ = edge.getDestinationNode();
            this.checkNodeForCycles(succ, stack, checkedNodes);
        }
        stack.removeLast();
        checkedNodes.put(node, null);
    }

    private void addGarEdges() {
        int interGarOrderKey = -2147483647;
        for (GeneralizedOrderRequest gor : this.superplan.getGors()) {
            SdgGarNode prevGarNode = null;
            for (GeneralizedActionRequest gar : gor.getGars()) {
                boolean isComplete;
                SdgGarNode garNode = this.getGarNode(gar);
                boolean bl = isComplete = gar.getOutOfPlanQty() < gar.getRequestedQty();
                if (prevGarNode != null && isComplete) {
                    InterGarSdgEdge edge = new InterGarSdgEdge(interGarOrderKey++, prevGarNode, garNode);
                    this.incomingEdges.put(garNode, edge);
                    this.outgoingEdges.put(prevGarNode, edge);
                    this.allEdges.add(edge);
                }
                prevGarNode = isComplete ? garNode : null;
            }
        }
    }

    private void addIsolatedNodes() {
        for (SupplyRequest sr : this.superplan.getSupplyRequests()) {
            this.srNodes.computeIfAbsent(sr, SdgSrNode::new);
        }
        if (this.nodeMode == NodeMode.GOR) {
            for (GeneralizedOrderRequest gor : this.superplan.getGors()) {
                this.gorNodes.computeIfAbsent(gor, SdgGorNode::new);
            }
        }
        for (CustomerRequest cr : this.superplan.getCustomerRequests()) {
            this.crNodes.computeIfAbsent(cr, SdgCrNode::new);
        }
    }

    private StoreDependencyGraph createGraph() {
        StoreDependencyGraphImpl graph = new StoreDependencyGraphImpl(this.superplan);
        ArrayList<AbstractSdgNode> nodes = Lists.newArrayListWithCapacity(this.materialNodes.size() + this.garNodes.size() + this.gorNodes.size() + this.srNodes.size() + this.crNodes.size() + this.esaNodes.size());
        nodes.addAll(this.materialNodes.values());
        nodes.addAll(this.garNodes.values());
        nodes.addAll(this.gorNodes.values());
        nodes.addAll(this.srNodes.values());
        nodes.addAll(this.crNodes.values());
        nodes.addAll(this.esaNodes.values());
        for (AbstractSdgNode node : nodes) {
            ImmutableListMultimap.Builder incomingEdgesBuilder = ImmutableListMultimap.builder();
            node.allIncomingEdges = ImmutableList.copyOf(this.incomingEdges.get((Object)node));
            for (SdgEdge edge : node.allIncomingEdges) {
                incomingEdgesBuilder.put(edge.getSourceNode(), edge);
            }
            node.incomingEdges = incomingEdgesBuilder.build();
            ImmutableListMultimap.Builder outgoingEdgesBuilder = ImmutableListMultimap.builder();
            node.allOutgoingEdges = ImmutableList.copyOf(this.outgoingEdges.get((Object)node));
            for (SdgEdge edge : node.allOutgoingEdges) {
                outgoingEdgesBuilder.put(edge.getDestinationNode(), edge);
            }
            node.outgoingEdges = outgoingEdgesBuilder.build();
            node.graph = graph;
        }
        graph.srNodes = ImmutableMap.copyOf(this.srNodes);
        graph.esaNodes = ImmutableMap.copyOf(this.esaNodes);
        graph.gorNodes = ImmutableMap.copyOf(this.gorNodes);
        graph.garNodes = ImmutableMap.copyOf(this.garNodes);
        graph.crNodes = ImmutableMap.copyOf(this.crNodes);
        graph.materialNodes = ImmutableMap.copyOf(this.materialNodes);
        graph.allNodes = ImmutableList.copyOf(nodes);
        graph.allEdges = ImmutableList.copyOf(this.allEdges);
        return graph;
    }

    void addEdge(AbstractSdgEdge edge) {
        this.incomingEdges.put(edge.getDestinationNode(), edge);
        this.outgoingEdges.put(edge.getSourceNode(), edge);
        this.allEdges.add(edge);
    }

    SdgMatprodNode getMaterialNode(Material mat) {
        return this.materialNodes.computeIfAbsent(mat, SdgMatprodNode::new);
    }

    SdgGarNode getGarNode(GeneralizedActionRequest gar) {
        Preconditions.checkState(this.nodeMode == NodeMode.GAR);
        return this.garNodes.computeIfAbsent(gar, SdgGarNode::new);
    }

    SdgGorNode getGorNode(GeneralizedOrderRequest gor) {
        Preconditions.checkState(this.nodeMode == NodeMode.GOR);
        return this.gorNodes.computeIfAbsent(gor, SdgGorNode::new);
    }

    SdgCrNode getCrNode(CustomerRequest cr) {
        return this.crNodes.computeIfAbsent(cr, SdgCrNode::new);
    }

    SdgSrNode getSrNode(SupplyRequest sr) {
        return this.srNodes.computeIfAbsent(sr, SdgSrNode::new);
    }

    SdgEsaNode getEsaNode(ExternalStoreActivity esa) {
        return this.esaNodes.computeIfAbsent(esa, SdgEsaNode::new);
    }

    public static enum NodeMode {
        GAR,
        GOR;

    }
}

